<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class JobAgeCategory extends Model 
{

    protected $table = 'job_age_categories';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('job_id', 'age_category_id');

    public function job()
    {
        return $this->belongsTo('App\Models\Job', 'job_id', 'id');
    }

    public function ageCategory()
    {
        return $this->belongsTo('App\Models\JobAgeCategory', 'age_category_id', 'id');
    }

}